## Same Hierarchy Tuple

Since icCube 4.8 it is possible to relax standard MDX constraint to allow several members of the same hierarchy in a tuple.




### Description

In standard MDX it is not possible to have a tuple with two members of the same hierarchy. So putting the same hierarchy on two axis will return an error. The 'standard' solution is duplicating the dimension, but this not only implies changing the schema but also decrease the efficiency of the Server.

In icCube since version 4.8, if `icCube.dimensionalityCheck` property is set to false, it's possible to relax this constraint. Now, the following syntax is valid :

<pre>
WITH
  MEMBER [Correlation] AS Correlation( [Products] , ([Geography].current(0),[Measures].[Sales]), ([Geography].current(1),[Measures].[Sales]) )
SELECT
  [Geography].[Countries] on 0,
  [Geography].[Countries] on 1
FROM [SALES]
WHERE [Correlation]
</pre>

How this new feature works :

Multiple members of the same hierarchy can be used in axis and calculated members but will generate an error if used in a where clause or a subquery.

Both current and currentMember will return a set if the tuple has more than one member for the requested hierarchy.

**IMPORTANT**: crossjoin and set will perform an exist on each tuples. Some tuples will be removed even though they might exist. For example the tuple `( [Geography].[France],[Geography].[US] )` will be removed. We advise not to rely on this feature.

The fact evaluation of a tuple will perform an `AND` of all members, including those of the same hierarchy. So unless you have a parent-child or many-to-many relation the evaluation of the tuple will return empty. For example, `( [Geography].[France],[Geography].[US] )` is empty. This is the same behavior as the one we would get by using the two different hierarchies.

Please check the example below and try on your own to get a better understanding.



### Since Version

4.8


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Two Axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

It's possible to have the same hierarchy on both axis. As the [Geography] hierarchy does not define a many-to-many relation only the diagonal has some values.

**Query**

```
SELECT
    NON EMPTY [Geography].[Geo].[Country] on 0,
    NON EMPTY [Geography].[Geo].[Country] on 1
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
 <td></td>
 <td></td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td></td>
 <td>4</td>
 <td></td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td></td>
 <td></td>
 <td>3</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td></td>
 <td></td>
 <td></td>
 <td>248</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Two Axis - Current and Calculated Member

</div>

<div class="ic3-mdx-example-body" style="display:none">

We can use the current function to redefine a tuple. In this example, we create a new tuple taking only the first member of the tuple. The second one, defined by Axis(0) is ignored.

**Query**

```
WITH
    MEMBER [MyMeasure] AS ([Geography].[Geo].current(0), [Measures].[Amount] )
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Country] on 1
FROM [SALES]
WHERE [MyMeasure]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">America</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>768</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [MyMeasure] AS ([Geography].[Geo].[Continent].[America], [Measures].[Amount] )
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Country] on 1
FROM [SALES]
WHERE [MyMeasure]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Two Axis - Correlation 

</div>

<div class="ic3-mdx-example-body" style="display:none">

Same as the example before, but using a more meaningful scenario, we're calculating correlations between sales.

**Query**

```
WITH
    MEMBER [Correlation] AS Round(Correlation( [Product].[Prod].[Licence] , 0.0+([Geography].[Geo].current(0),[Measures].defaultMember), 0.0+([Geography].[Geo].current(1),[Measures].defaultMember) ),4)
SELECT
    nonempty( [Geography].[Geo].[Country],[Measures].defaultMember) on 0,
    nonempty( [Geography].[Geo].[Country],[Measures].defaultMember) on 1
FROM [SALES]
WHERE [Correlation]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>1.0</td>
 <td>-0.3333</td>
 <td>-0.3333</td>
 <td>0.7826</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>-0.3333</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>-0.5153</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>-0.3333</td>
 <td>1.0</td>
 <td>1.0</td>
 <td>-0.5153</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>0.7826</td>
 <td>-0.5153</td>
 <td>-0.5153</td>
 <td>1.0</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Two Axis - current function

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to see how the function current (or currentMember) works. In our example, we're taking the first member, the one defined by the COLUMNS (0).

**Query**

```
WITH
    MEMBER [MyMeasure] AS [Geography].[Geo].current(0).name
SELECT
    [Geography].[Geo].[Country] on 0,
    [Geography].[Geo].[Country] on 1
FROM [SALES]
WHERE [MyMeasure]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>Canada</td>
 <td>Mexico</td>
 <td>United States</td>
 <td>Venezuela</td>
 <td>France</td>
 <td>Spain</td>
 <td>Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>Canada</td>
 <td>Mexico</td>
 <td>United States</td>
 <td>Venezuela</td>
 <td>France</td>
 <td>Spain</td>
 <td>Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>Canada</td>
 <td>Mexico</td>
 <td>United States</td>
 <td>Venezuela</td>
 <td>France</td>
 <td>Spain</td>
 <td>Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>Canada</td>
 <td>Mexico</td>
 <td>United States</td>
 <td>Venezuela</td>
 <td>France</td>
 <td>Spain</td>
 <td>Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>Canada</td>
 <td>Mexico</td>
 <td>United States</td>
 <td>Venezuela</td>
 <td>France</td>
 <td>Spain</td>
 <td>Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>Canada</td>
 <td>Mexico</td>
 <td>United States</td>
 <td>Venezuela</td>
 <td>France</td>
 <td>Spain</td>
 <td>Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>Canada</td>
 <td>Mexico</td>
 <td>United States</td>
 <td>Venezuela</td>
 <td>France</td>
 <td>Spain</td>
 <td>Switzerland</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Two Axis - current function II

</div>

<div class="ic3-mdx-example-body" style="display:none">

The current, or currentMember, function returns a set if the tuple has more than one member. In our example, we're using SetToStr to check the difference.

**Query**

```
WITH
    MEMBER [MyMeasure] AS SetToStr( [Geography].[Geo].current )
SELECT
    [Geography].[Geo].[Country] on 0,
    [Geography].[Geo].[Country] on 1
FROM [SALES]
WHERE [MyMeasure]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>{[Geography].[Geo].[Country].&[CA],[Geography].[Geo].[Country].&[CA]}</td>
 <td>{[Geography].[Geo].[Country].&[MX],[Geography].[Geo].[Country].&[CA]}</td>
 <td>{[Geography].[Geo].[Country].&[US],[Geography].[Geo].[Country].&[CA]}</td>
 <td>{[Geography].[Geo].[Country].&[VE],[Geography].[Geo].[Country].&[CA]}</td>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[CA]}</td>
 <td>{[Geography].[Geo].[Country].&[ES],[Geography].[Geo].[Country].&[CA]}</td>
 <td>{[Geography].[Geo].[Country].&[CH],[Geography].[Geo].[Country].&[CA]}</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>{[Geography].[Geo].[Country].&[CA],[Geography].[Geo].[Country].&[MX]}</td>
 <td>{[Geography].[Geo].[Country].&[MX],[Geography].[Geo].[Country].&[MX]}</td>
 <td>{[Geography].[Geo].[Country].&[US],[Geography].[Geo].[Country].&[MX]}</td>
 <td>{[Geography].[Geo].[Country].&[VE],[Geography].[Geo].[Country].&[MX]}</td>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[MX]}</td>
 <td>{[Geography].[Geo].[Country].&[ES],[Geography].[Geo].[Country].&[MX]}</td>
 <td>{[Geography].[Geo].[Country].&[CH],[Geography].[Geo].[Country].&[MX]}</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>{[Geography].[Geo].[Country].&[CA],[Geography].[Geo].[Country].&[US]}</td>
 <td>{[Geography].[Geo].[Country].&[MX],[Geography].[Geo].[Country].&[US]}</td>
 <td>{[Geography].[Geo].[Country].&[US],[Geography].[Geo].[Country].&[US]}</td>
 <td>{[Geography].[Geo].[Country].&[VE],[Geography].[Geo].[Country].&[US]}</td>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[US]}</td>
 <td>{[Geography].[Geo].[Country].&[ES],[Geography].[Geo].[Country].&[US]}</td>
 <td>{[Geography].[Geo].[Country].&[CH],[Geography].[Geo].[Country].&[US]}</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>{[Geography].[Geo].[Country].&[CA],[Geography].[Geo].[Country].&[VE]}</td>
 <td>{[Geography].[Geo].[Country].&[MX],[Geography].[Geo].[Country].&[VE]}</td>
 <td>{[Geography].[Geo].[Country].&[US],[Geography].[Geo].[Country].&[VE]}</td>
 <td>{[Geography].[Geo].[Country].&[VE],[Geography].[Geo].[Country].&[VE]}</td>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[VE]}</td>
 <td>{[Geography].[Geo].[Country].&[ES],[Geography].[Geo].[Country].&[VE]}</td>
 <td>{[Geography].[Geo].[Country].&[CH],[Geography].[Geo].[Country].&[VE]}</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>{[Geography].[Geo].[Country].&[CA],[Geography].[Geo].[Country].&[FR]}</td>
 <td>{[Geography].[Geo].[Country].&[MX],[Geography].[Geo].[Country].&[FR]}</td>
 <td>{[Geography].[Geo].[Country].&[US],[Geography].[Geo].[Country].&[FR]}</td>
 <td>{[Geography].[Geo].[Country].&[VE],[Geography].[Geo].[Country].&[FR]}</td>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[FR]}</td>
 <td>{[Geography].[Geo].[Country].&[ES],[Geography].[Geo].[Country].&[FR]}</td>
 <td>{[Geography].[Geo].[Country].&[CH],[Geography].[Geo].[Country].&[FR]}</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>{[Geography].[Geo].[Country].&[CA],[Geography].[Geo].[Country].&[ES]}</td>
 <td>{[Geography].[Geo].[Country].&[MX],[Geography].[Geo].[Country].&[ES]}</td>
 <td>{[Geography].[Geo].[Country].&[US],[Geography].[Geo].[Country].&[ES]}</td>
 <td>{[Geography].[Geo].[Country].&[VE],[Geography].[Geo].[Country].&[ES]}</td>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[ES]}</td>
 <td>{[Geography].[Geo].[Country].&[ES],[Geography].[Geo].[Country].&[ES]}</td>
 <td>{[Geography].[Geo].[Country].&[CH],[Geography].[Geo].[Country].&[ES]}</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>{[Geography].[Geo].[Country].&[CA],[Geography].[Geo].[Country].&[CH]}</td>
 <td>{[Geography].[Geo].[Country].&[MX],[Geography].[Geo].[Country].&[CH]}</td>
 <td>{[Geography].[Geo].[Country].&[US],[Geography].[Geo].[Country].&[CH]}</td>
 <td>{[Geography].[Geo].[Country].&[VE],[Geography].[Geo].[Country].&[CH]}</td>
 <td>{[Geography].[Geo].[Country].&[FR],[Geography].[Geo].[Country].&[CH]}</td>
 <td>{[Geography].[Geo].[Country].&[ES],[Geography].[Geo].[Country].&[CH]}</td>
 <td>{[Geography].[Geo].[Country].&[CH],[Geography].[Geo].[Country].&[CH]}</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Matrix

</div>

<div class="ic3-mdx-example-body" style="display:none">

Same example as the correlation with two axis but using the Matrix function.

**Query**

```
WITH
    MEMBER [Correlation] AS Round(Correlation( [Product].[Prod].[Licence] , 0.0+([Geography].[Geo].current(0),[Measures].defaultMember), 0.0+([Geography].[Geo].current(1),[Measures].defaultMember) ),4)
    MEMBER [Matrix] AS Matrix( [S1], [S1], [Correlation] )
    SET [S1] AS nonempty( [Geography].[Geo].[Country],[Measures].defaultMember)
SELECT
    [Matrix] on 0
FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Matrix</td>
</tr>
<tr>
 <td>[[1.0, -0.3333, -0.3333, 0.7826], [-0.3333, 1.0, 1.0, -0.5153], [-0.3333, 1.0, 1.0, -0.5153], [0.7826, -0.5153, -0.5153, 1.0]]</td>
</tr>
</table>



 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Crossjoin - performing exist

</div>

<div class="ic3-mdx-example-body" style="display:none">

This example shows how the exist is performed when a crossjoin is applied.

**Query**

```
SELECT
    [Geography].[Geo].[Continent] * [Geography].[Geo].[Country] on 0
FROM [SALES]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">America</td>
  <td class="ic3-mdx-result-cell-header">America</td>
  <td class="ic3-mdx-result-cell-header">America</td>
  <td class="ic3-mdx-result-cell-header">America</td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
  <td class="ic3-mdx-result-cell-header">Europe</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">Canada</td>
  <td class="ic3-mdx-result-cell-header">Mexico</td>
  <td class="ic3-mdx-result-cell-header">United States</td>
  <td class="ic3-mdx-result-cell-header">Venezuela</td>
  <td class="ic3-mdx-result-cell-header">France</td>
  <td class="ic3-mdx-result-cell-header">Spain</td>
  <td class="ic3-mdx-result-cell-header">Switzerland</td>
</tr>
<tr>
 <td></td>
 <td></td>
 <td>768</td>
 <td></td>
 <td>4</td>
 <td>3</td>
 <td>248</td>
</tr>
</table>



 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Throws an error if the property is set to true

</div>

<div class="ic3-mdx-example-body" style="display:none">

In order to relax the XMLA standard constraint the flag dimensionalityCheck needs to be set to true.

**Query**

```
SELECT
    NON EMPTY [Geography].[Geo].[Country] on 0,
    NON EMPTY [Geography].[Geo].[Country] on 1
FROM [Sales]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_AXIS_SELECT_MULTIPLE_HIERARCHY](icCubeError.md#olap_axis_select_multiple_hierarchy)</td></tr><tr><td>Error Message</td><td>

the hierarchy '[Geography].[Geo]' cannot be selected in more than one axis</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Where clause - throws an error

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if used in a where clause.

**Query**

```
SELECT
    [Measures].defaultMember on 0
FROM [SALES]
WHERE ( [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_TUPLE_DIMENSIONALITY](icCubeError.md#olap_invalid_tuple_dimensionality)</td></tr><tr><td>Error Message</td><td>

invalid tuple dimensionality '[Geography].[Geo],[Geography].[Geo]' - ''</td></tr></table>


 
</div>

                                                                         

### See Also


[Current](Current.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
